<%@ page import="com.bea.p13n.cache.* "%>

<html>
<head>
<style type="text/css">
BODY {
FONT-SIZE: xx-small; FONT-FAMILY: verdana,arial,sans-serif
}
TD {
FONT-SIZE: xx-small; FONT-FAMILY: verdana,arial,sans-serif;
   }
DIV {
FONT-SIZE: xx-small; FONT-FAMILY: verdana,arial,sans-serif
}
SPAN {
FONT-SIZE: xx-small; FONT-FAMILY: verdana,arial,sans-serif
}
A {
FONT-SIZE: xx-small; FONT-FAMILY: verdana,arial,sans-serif
}
A {
COLOR: #006699; TEXT-DECORATION: none
}
</style>
</head>
<body>
<h2>Weblogic Portal Cache List</h2>

<b>Overview</b>

<br><br>
This information could be particularly useful to developers who are tuning their caches during load testing for optimal application performance, and for administrators who are monitoring cache usage in production.  When modifying the maximum cache sizes, keep in mind the amount of memory that is available to your application and monitor the system memory to determine the effects.  See the <a href=http://e-docs.bea.com/wlp/docs81/bestprac/perform.html>Portal Performance Tuning Guide</a> for an overview on Weblogic Portal caching.


<hr>

<p>
  This page contains a list of the caches created by the Weblogic Portal product.
  Each of these caches is an instance of <a href=http://e-docs.bea.com/workshop/docs81/doc/en/portal/java-class/com/bea/p13n/cache/Cache.html><i>com.bea.p13n.cache.Cache</i></a>.
</p>

<p>
  Statically defined caches are established in the application-config.xml file for
the application. These can be configured in the WebLogic Administration Portal (Portal Admin Tools) by navigating to: <br>
  Service Administration (under Configuration Settings) -> Cache Manager. Only statically defined caches appear in this location.
</p>

<p>
  The Portal product also makes use of dynamically generated caches. This JSP is the best way to explore these caches. You may generally make dynamic caches administrable by adding entries in the application-config.xml file.
</p>

<hr>

<%
  int numberOfRowsToDisplayTableHeader=5;
  // process the form submission.
  String action = (String)request.getParameter("action");
  String cacheName = (String)request.getParameter("cacheName");
  String[] allCaches = CacheFactory.getCacheNames();
  String[] allSortedCaches = CacheFactory.getCacheNames();
  java.util.Arrays.sort(allSortedCaches, java.text.Collator.getInstance());
  String[] cachesToProcess = null;

  if(action != null && cacheName != null) 
  {

    // get the caches that we are operating on
    if("all".equals(cacheName)) 
    {
      cachesToProcess = allCaches;

    } else 
    {
      cachesToProcess = new String[] { cacheName };
    }

    // perform the action.
    for(int i = 0; i < cachesToProcess.length; i++) 
    {
      Cache curCache = CacheFactory.getCache(cachesToProcess[i]);

      if (curCache != null) 
      {
        if(action.equals("Clear")) 
	{
          curCache.clear();

        } else if(action.equals("ResetStats")) 
        {
          curCache.resetStats();

        } else 
	{
          break;
        }
      }
    }
  }
%>

<table>
  <tr>
    <td>
       <form name="form" action="dynamicCacheList.jsp"/>
         <input type="submit" value="Refresh List">
       </form>
    </td>
    <td>
       <form name="form" action="dynamicCacheList.jsp"/>
         <input type="hidden" name="action" value="Clear" >
         <input type="hidden" name="cacheName" value="all" >
         <input type="submit" value="Clear All Caches">
       </form>
    </td>
    <td>
       <form name="form" action="dynamicCacheList.jsp"/>
         <input type="hidden" name="action" value="ResetStats" >
         <input type="hidden" name="cacheName" value="all" >
         <input type="submit" value="Reset All Stats">
       </form>
    </td>
  </tr>
</table>

<table border="1">
  <tr bgcolor="#799cbf" style="font-weight:bold;color:#ffffff;">
    <td>Cache Name</td>
    <td>Enabled</td>
    <td>Current Size</td>
    <td>Maximum Size</td>
    <td>TTL (milliseconds)</td>
    <td>Hit Count</td>
    <td>Miss Count</td>
    <td>Hit Rate</td>
    <td>Clear Cache</td>
    <td>Reset Stats</td>
    <td>Cache Contents</td>
  </tr>

<%
  int rowCount = 0;
  for (int i = 0; i < allSortedCaches.length; i++)
  {
    if (i%numberOfRowsToDisplayTableHeader == 0 && i > 0)
    {
%>
      <tr bgcolor="#799cbf" style="font-weight:bold;color:#ffffff;">
        <td>Cache Name</td>
        <td>Enabled</td>
        <td>Current Size</td>
        <td>Maximum Size</td>
        <td>TTL (milliseconds)</td>
        <td>Hit Count</td>
        <td>Miss Count</td>
        <td>Hit Rate</td>
        <td>Clear Cache</td>
        <td>Reset Stats</td>
        <td>Cache Contents</td>
      </tr>
<%
    }

%>
<%
    String curCacheName = allSortedCaches[i];
    Cache curCache = CacheFactory.getCache(curCacheName);
    if (curCache != null)
    {
      String bgcolor = null;
      if(i % 2 == 0) 
      {
        bgcolor = "white";

      } else 
      {
        bgcolor = "#C0C0C0";
      }
%>
    <tr valign="top" bgcolor="<%= bgcolor %>">
      <td><%= curCacheName %></td>
      <td><%= curCache.isEnabled() %></td>
      <td><%= curCache.size() %></td>
      <td><%= curCache.getMaxEntries() %></td>
      <td><%= curCache.getTtl() %></td>
      <td><%= curCache.getHitCount() %></td>
      <td><%= curCache.getMissCount() %></td>
      <td><%= curCache.getHitRate() %>%</td>
      <td>
        <form name="form" action="dynamicCacheList.jsp"/>
          <input type="hidden" name="cacheName" value="<%=curCacheName%>" />
          <input type="hidden" name="action" value="Clear" />
          <input type="submit" value="Clear Cache" />
        </form>
      </td>
      <td>
        <form name="form" action="dynamicCacheList.jsp"/>
          <input type="hidden" name="cacheName" value="<%=curCacheName%>" />
          <input type="hidden" name="action" value="ResetStats" />
          <input type="submit" value="Reset Stats" />
        </form>
      </td>
      <td>
        <form name="form" action="dynamicCacheListDetail.jsp"/>
          <input type="hidden" name="cacheName" value="<%=curCacheName%>" />
          <input type="hidden" name="action" value="CacheContents" />
          <input type="submit" value="Show Cache Contents" />
        </form>
      </td>
  </tr>
<%
    }
  }
%>
  </table>
 </form>
</body>
</html>
